/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity;

import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.entity.Entity;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.item.Item;
import net.jayjay.dangerzone.item.Items;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.sound.Sound;
import net.jayjay.dangerzone.world.World;
import org.lwjgl.opengl.GL11;

public class EntityItem
extends Entity {
    private float xd;
    private float yd;
    private float zd;
    private int age;
    private int lifetime;
    private int pickupDelay;
    private float size;
    private static int itemCount = 0;
    private static final int MAX_ITEMS = 256;
    private int id;
    public int count;

    public EntityItem(World world) {
        super(world);
    }

    public EntityItem(World level, float x, float y, float z, Item item, int count) {
        super(level);
        if (itemCount >= 256) {
            System.out.println("EntityBlockItem limit reached: " + itemCount + "/" + 256);
            this.remove();
            return;
        }
        ++itemCount;
        this.setSize(0.5f, 0.5f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x + 0.5f, y + 0.5f, z + 0.5f);
        this.xd = (float)(Math.random() * 0.2 - 0.1);
        this.yd = 0.2f;
        this.zd = (float)(Math.random() * 0.2 - 0.1);
        this.size = 2.5f;
        this.lifetime = 6000;
        this.pickupDelay = 20;
        this.age = 0;
        this.onGround = false;
        this.id = Items.getItemID(item.itemTag);
        this.count = count;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
            return;
        }
        this.yd -= 0.04f;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98f;
        this.yd *= 0.98f;
        this.zd *= 0.98f;
        if (this.onGround) {
            this.xd *= 0.7f;
            this.zd *= 0.7f;
            this.yd *= -0.5f;
        }
        if (this.pickupDelay > 0) {
            --this.pickupDelay;
        } else {
            AABB itemBox;
            EntityPlayer player = DZ2.theDangerZone.thePlayer;
            if (player != null && !player.removed && !this.removed && (itemBox = this.getBoundingBox()) != null) {
                itemBox = itemBox.expand(0.5f, 0.5f, 0.5f);
                AABB playerBox = player.getBoundingBox();
                if (playerBox != null && itemBox.intersects(playerBox)) {
                    this.onPlayerPickup(player);
                }
            }
        }
    }

    private void onPlayerPickup(EntityPlayer player) {
        System.out.println("EntityItem picked up by player: ID=" + this.id + " Count=" + this.count);
        if (DZ2.theDangerZone.ci.addItem(this.id, this.count, false)) {
            this.remove();
        }
    }

    @Override
    public void setEntityBB(float width, float height) {
        this.bbWidth = width;
        this.bbHeight = height;
        float w = width;
        float h2 = height / 2.0f;
        this.bb = new AABB(this.x - w, this.y - h2, this.z - w, this.x + w, this.y + h2, this.z + w);
    }

    @Override
    public AABB getBoundingBox() {
        return this.bb;
    }

    @Override
    public void render(float partialTicks) {
        Tesselator t = Tesselator.INSTANCE;
        GL11.glEnable(3553);
        boolean wasLightingEnabled = GL11.glGetBoolean(2896);
        GL11.glDisable(2896);
        t.begin(7);
        t.setColor(1.0f, 1.0f, 1.0f);
        float bob = (float)Math.sin(((float)this.age + partialTicks) * 0.1f) * 0.1f;
        float yOffset = bob * 0.5f;
        float x = this.xo + (this.x - this.xo) * partialTicks;
        float y = this.yo + (this.y - this.yo) * partialTicks + yOffset;
        float z = this.zo + (this.z - this.zo) * partialTicks;
        float xa = -((float)Math.cos((double)DZ2.theDangerZone.thePlayer.yRot * Math.PI / 180.0));
        float za = -((float)Math.sin((double)DZ2.theDangerZone.thePlayer.yRot * Math.PI / 180.0));
        float xa2 = -za * (float)Math.sin((double)DZ2.theDangerZone.thePlayer.xRot * Math.PI / 180.0);
        float za2 = xa * (float)Math.sin((double)DZ2.theDangerZone.thePlayer.xRot * Math.PI / 180.0);
        float ya = (float)Math.cos((double)DZ2.theDangerZone.thePlayer.xRot * Math.PI / 180.0);
        Items.items[this.id].renderFaceBillboarded(t, x, y, z, xa, ya, za, xa2, za2, this.size);
        t.flush();
        if (wasLightingEnabled) {
            GL11.glEnable(2896);
        }
    }

    @Override
    public void remove() {
        this.removed = true;
        Sound.playDZ2Sound("pickup");
        --itemCount;
    }
}

